<!-- EverWardrobe Website -->
<!-- By Fasika Kelile -->
<!-- STREET MUSE RESULT PAGE html -->
<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
  <!-- Character Encoding -->
  <meta charset="utf-8">
  <!-- Viewport (Responsive Design) -->
  <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover, interactive-widget=overlays-content">
  
  <!-- Description (SEO) -->
  <meta name="description" content="You're a Street Muse! Discover your style persona and explore a personalized capsule wardrobe curated just for you.">
  
  <!-- Color scheme (respects user preference) -->
  <meta name="color-scheme" content="light dark" />
  <meta name="theme-color" content="#D86235" media="(prefers-color-scheme: light)" />
  <meta name="theme-color" content="#3D3A37" media="(prefers-color-scheme: dark)" />
  
  <!-- Canonical link -->
  <link rel="canonical" href="https://everwardrobe.com/personas/street-muse.php" />
  
  <!-- Social previews (Open Graph) -->
  <meta property="og:type" content="website" />
  <meta property="og:site_name" content="EverWardrobe" />
  <meta property="og:title" content="Street Muse — Your Style Persona — EverWardrobe" />
  <meta property="og:description" content="You're a Street Muse! Effortlessly cool, street-ready, and a social media trendsetter. Explore your personalized style." />
  <meta property="og:url" content="https://everwardrobe.com/personas/street-muse.php" />
  <meta property="og:image" content="https://everwardrobe.com/images/og-street-muse.jpg" />
  <meta property="og:image:alt" content="Street Muse Style Persona" />
  
  <!-- Twitter Card -->
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Street Muse — Your Style Persona — EverWardrobe" />
  <meta name="twitter:description" content="Effortlessly cool, street-ready, and a social media trendsetter. Explore your personalized capsule wardrobe." />
  <meta name="twitter:image" content="https://everwardrobe.com/images/og-street-muse.jpg" />
  
  <!-- Keywords -->
  <meta name="keywords" content="street muse, style persona, capsule wardrobe, street style, fashion, persona quiz results">
  
  <!-- Author & SEO -->
  <meta name="author" content="EverWardrobe">
  <meta name="robots" content="index, follow" />
  <meta name="referrer" content="strict-origin-when-cross-origin" />
  
  <!-- Page Title -->
  <title>EverWardrobe – Street Muse Result</title>
  
  <!-- Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@700;900&family=Plus+Jakarta+Sans:wght@400;500;700&display=swap" rel="stylesheet" />
  
  <!-- Stylesheet -->
  <link rel="stylesheet" href="../main-style.css" />
</head>

<body id="persona-result-street-muse">
<header class="site-header" role="banner">
    <div class="container">
      <!-- Logo (Image) -->
      <a class="brand" href="/quiz.php">
        <img src="../assets/logo/ever-wardrobe-logo.png" alt="EverWardrobe Logo" width="50" height="50">
      </a>
  
      <!-- Hamburger Menu Button (Mobile) -->
      <button class="hamburger" aria-label="Toggle navigation" aria-expanded="false">
        <span></span>
        <span></span>
        <span></span>
      </button>
  
      <!-- Primary Navigation -->
      <nav class="primary-nav" aria-label="Primary" aria-expanded="false">
        <a href="/quiz.php">Start Your Style Quiz</a>
        <a href="/explore-personas.php">Explore Personas</a>
        <a href="/about-us.php" aria-current="page">About Us</a>
      </nav>
    </div>
  </header>

  <main role="main">
    <section class="lede">
      <h1>STREET MUSE</h1>
      <div class="lede-grid">
        <div class="lede-left"></div>
        <div class="lede-right">
          <h2>You are a Street Muse Fashion Icon!</h2>
          <p>You're the girl that effortlessly blends trendy streetwear with a cool-girl vibe. Everyone wants to save you to their mood boards. Your style is thought-out yet current, mixing comfort with statement pieces in a way that feels casual but calculated.</p>
          <p><span class="token">Think:</span> Thrifted finds, oversized jackets, crop tops, mini skirts, tights, statement boots, bucket hats.</p>
          <p><span class="token">Vibe:</span> Effortless cool, street-ready, social media trendsetter.</p>
          <div class="actions" role="group" aria-label="Result actions">
            <!--<a class="btn" href="#">Your Persona Analysis</a>-->
            <a class="btn" href="../quiz.php">Retake Quiz</a>
          </div>
        </div>
      </div>
    </section>

    <section class="bottom-wrap" aria-label="Street Muse outfit preview">
      <div class="film-strip">
        <figure class="frame"><img loading="eager" src="../assets/images/outfits/street-muse/everyday/street-muse-1.jpg" alt="Street Muse look" width="1200" height="800" /></figure>
        <figure class="frame"><img loading="lazy" src="../assets/images/outfits/street-muse/career-wear/street-muse-1.jpg" alt="Portrait" width="1200" height="800" /></figure>
        <figure class="frame"><img loading="lazy" src="../assets/images/outfits/street-muse/everyday/street-muse-1.jpg" alt="Statement coat" width="1200" height="800" /></figure>
        <figure class="frame"><img loading="eager" src="../assets/images/outfits/street-muse/everyday/street-muse-1.jpg" alt="Street Muse look" width="1200" height="800" /></figure>
        <figure class="frame"><img loading="lazy" src="../assets/images/outfits/street-muse/career-wear/street-muse-1.jpg" alt="Portrait" width="1200" height="800" /></figure>
        <figure class="frame"><img loading="lazy" src="../assets/images/outfits/street-muse/statememt/street-muse-1.jpg" alt="Statement coat" width="1200" height="800" /></figure>
        <figure class="frame"><img loading="eager" src="../assets/images/outfits/street-muse/everyday/street-muse-1.jpg" alt="Street Muse look" width="1200" height="800" /></figure>
        <figure class="frame"><img loading="lazy" src="../assets/images/outfits/street-muse/career-wear/street-muse-1.jpg" alt="Portrait" width="1200" height="800" /></figure>
        <figure class="frame"><img loading="lazy" src="../assets/images/outfits/street-muse/statememt/street-muse-1.jpg" alt="Statement coat" width="1200" height="800" /></figure>
      </div>
      <div class="portrait-wrap"><img loading="eager" src="../assets/images/personas/street-muse-2.webp" alt="Street Muse portrait" width="900" height="1200" /></div>
      <a class="cta" href="../capsule-room/street-muse-capsule-room.php">Your Capsule Room</a>
    </section>
  </main>

  <footer class="site-footer" role="contentinfo">
    <!-- Intro banner (headline + short copy + decorative images) -->
    <div class="intro">
      <div>
        <h2>Dress with clarity.</h2>
        <p>We curate capsule wardrobes that make getting dressed easy.</p>
      </div>
      <!-- Decorative polaroids (purely visual placeholders) -->
      <figure aria-hidden="true">
        <span></span><span></span>
      </figure>
    </div>

    <!-- Cocoa content card (orange border on top of this) -->
    <div class="content">
      <picture>
        <img
          src="../assets/logo/everwardrobe-white.png"
          alt="EverWardrobe"
          loading="lazy"
          decoding="async"
          width="220"
          height="110"
        />
      </picture>

      <section>
        <p><strong>Join our newsletter</strong></p>
        <form action="#" method="post" novalidate>
          <label class="sr-only" for="email">Email address</label>
          <input type="email" id="email" name="email" placeholder="Your email" required>
          <button type="submit">Subscribe</button>
        </form>
        <!-- Social icon slots — drop your SVGs inside the links -->
      </section>

      <nav aria-label="Footer navigation">
        <ul>
          <li><a href="/quiz.php">Take Quiz</a></li>
          <li><a href="/explore-personas.php">Explore Personas</a></li>
          <li><a href="/capsule-room.php">Capsule Room</a></li>
          <li><a href="/about-us.php">About Us</a></li>
        </ul>
      </nav>
    </div>

    <!-- Legal row -->
    <div class="legal">
      <nav aria-label="Legal">
        <a href="./pages/accessibility.php">Accessibility Statement</a>
        <a href="./pages/privacy.php">Privacy</a>
        <a href="./pages/terms.php">Terms</a>
        <a href="./pages/sustainability.php">Sustainability</a>
      </nav>
      <p>© 2024 <span>EverWardrobe</span></p>
    </div>
  </footer>

  <script src="/script.js" defer></script>

</body>
</html>