<!-- EverWardrobe Website -->
<!-- By Fasika Kelile -->
<!-- QUIZ PAGE html -->
<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
  <!-- Character Encoding -->
  <meta charset="utf-8">
  <!-- Viewport (Responsive Design) -->
  <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover, interactive-widget=overlays-content">
  
  <!-- Description (SEO) -->
  <meta name="description" content="Discover your style persona with a quick, visual quiz. Explore personalized capsules you can mix, match, and actually wear.">
  
  <!-- Color scheme (respects user preference) -->
  <meta name="color-scheme" content="light dark" />
  <meta name="theme-color" content="#FFF7F0" media="(prefers-color-scheme: light)" />
  <meta name="theme-color" content="#3D3A37" media="(prefers-color-scheme: dark)" />
  
  <!-- Canonical link -->
  <link rel="canonical" href="https://everwardrobe.com/quiz.php" />
  
  <!-- Social previews (Open Graph) -->
  <meta property="og:type" content="website" />
  <meta property="og:site_name" content="EverWardrobe" />
  <meta property="og:title" content="Your Style Persona Quiz — EverWardrobe" />
  <meta property="og:description" content="A quick, visual quiz that celebrates diverse styles and sizes. Discover your style persona and build a capsule wardrobe that works for your real life." />
  <meta property="og:url" content="https://everwardrobe.com/quiz.php" />
  <meta property="og:image" content="https://everwardrobe.com/images/og-quiz.jpg" />
  <meta property="og:image:alt" content="EverWardrobe Style Persona Quiz" />
  
  <!-- Twitter Card -->
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Your Style Persona Quiz — EverWardrobe" />
  <meta name="twitter:description" content="Discover your style persona and build a capsule wardrobe that works for you." />
  <meta name="twitter:image" content="https://everwardrobe.com/images/og-quiz.jpg" />
  
  <!-- Keywords -->
  <meta name="keywords" content="capsule wardrobe, curated outfits, fashion quiz, style persona, ootd, editorials, fashion styling">
  
  <!-- Author & SEO -->
  <meta name="author" content="EverWardrobe">
  <meta name="robots" content="index, follow" />
  <meta name="referrer" content="strict-origin-when-cross-origin" />
  
  <!-- Page Title -->
  <title>Your Style Persona Quiz — EverWardrobe</title>
  
  <!-- Fonts (brand-locked) -->
  <link rel="preconnect" href="https://fonts.googleapis.com" />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@600;700&family=Plus+Jakarta+Sans:wght@400;500;700&display=swap" rel="stylesheet" />
  
  <!-- Stylesheet -->
  <link rel="stylesheet" href="main-style.css" />
</head>
<body id="quiz-page">
  <?php include 'header.php'; ?>



  <!-- =====================================================
       SITE HEADER (single, page-level)
       ===================================================== -->

  <!-- =====================================================
       INTRO (HERO) — unchanged; single H1 lives here
       ===================================================== -->
  <main id="intro" aria-labelledby="introTitle">
    <section class="hero">
      <!-- LEFT: Copy -->
      <div class="hero-copy">
        <h1 id="introTitle">Your Style<br />Persona Quiz</h1>
        <p class="tagline">Style made personal. Outfits made easy.</p>
        <p class="lead">
          Your closet should work for you. This quiz helps you find your style
          persona and build a wardrobe that fits your life and vibe.
        </p>

        <div class="cta-row">
          <a href="#quiz1" class="btn primary">Start Quiz</a>
          <a href="/about-us.php" class="btn dark">About Us</a>
        </div>

        <ul class="facts">
          <li><strong>Quiz Type</strong><span>Visual</span></li>
          <li><strong>Questions</strong><span>20 questions</span></li>
          <li><strong>Time</strong><span>6–8 minutes</span></li>
        </ul>
      </div>

      <!-- RIGHT: Persona card -->
      <figure class="hero-card">
        <img
          src="assets/images/home/quiz-page-illustration.webp"
          alt="Preview collage of Edgy Cool look"
          decoding="async"
        />
      </figure>
    </section>
  </main>

  <!-- ===========================================================
       QUIZ SECTIONS (engine unchanged; removed inner <header>/<footer>)
       Sections breakdown:
       - Section 1: Q1–Q4 (4 questions)
       - Section 2: Q5–Q10 (6 questions)
       - Section 3: Q11–Q14 (4 questions)
       - Section 4: Q15–Q18 (4 questions)
       - Section 5: Q19–Q20 (2 questions)
       =========================================================== -->

  <!-- =========================
       Q1 — (multi) — Section 1 of 5 (25%)
       ========================= -->
  <section
    id="quiz1"
    class="quiz-section q1 quiz-section--grid-4"
    aria-labelledby="q1-title"
  >
    <div class="quiz-wrap">
      <!-- Top (was <header>) -->
      <div class="quiz-top">
        <div class="quiz-title">
          <h2 id="q1-title">
            Q1. What vibe are you going for when you're getting ready?
          </h2>
          <p class="note">(You can select more than one if it applies)</p>
        </div>
      </div>

      <!-- Stage -->
      <div class="quiz-stage">
        <div class="options">
          <!-- OPTION 1 -->
          <label class="option">
            <input
              type="checkbox"
              class="check"
              data-street_muse="3"
              data-style_rebel="1"
              data-effortlessly_polished="0"
              data-romantic_dreamer="0"
            />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img
                src="./assets/images/quiz/quiz-outfits/quiz-street-muse-5.jpg"
                alt="quiz-street-muse statement look" width="520" height="700"
                loading="lazy"
                decoding="async"
              />
            </span>
            <span class="opt-label">Edgy &amp; Cool</span>
          </label>

          <!-- OPTION 2 -->
          <label class="option">
            <input
              type="checkbox"
              class="check"
              data-street_muse="1"
              data-style_rebel="0"
              data-effortlessly_polished="3"
              data-romantic_dreamer="0"
            />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img
                src="./assets/images/quiz/quiz-outfits/quiz-effortlessly-polished-3.jpg"
                alt="quiz-effortlessly-polished career wear" width="520" height="700"
                loading="lazy"
                decoding="async"
              />
            </span>
            <span class="opt-label">Neat &amp; Put Together</span>
          </label>

          <!-- OPTION 3 -->
          <label class="option">
            <input
              type="checkbox"
              class="check"
              data-street_muse="0"
              data-style_rebel="0"
              data-effortlessly_polished="3"
              data-romantic_dreamer="1"
            />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img
                src="./assets/images/quiz/quiz-outfits/quiz-effortlessly-polished-6.jpg"
                alt="quiz-outfits/quiz-effortlessly-polished Statement Look" width="520" height="700"
                loading="lazy"
                decoding="async"
              />
            </span>
            <span class="opt-label">Classy, Sharp, Intentional</span>
          </label>

          <!-- OPTION 4 -->
          <label class="option">
            <input
              type="checkbox"
              class="check"
              data-street_muse="1"
              data-style_rebel="3"
              data-effortlessly_polished="0"
              data-romantic_dreamer="0"
            />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img
                src="./assets/images/quiz/quiz-outfits/quiz-romantic-dreamer-6.jpg"
                alt="quiz-romantic-dreamer statement look" width="520" height="700"
                loading="lazy"
                decoding="async"
              />
            </span>
            <span class="opt-label">Cool without trying</span>
          </label>
        </div>
      </div>

      <!-- Bottom (was <footer>) -->
      <div class="quiz-bottom">
        <div class="progress">
          <div class="progress-label" aria-live="off">Section 1 of 5</div>
          <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-current" style="--fill:25%;" aria-current="step"></li>
            <li class="dot"></li>
            <li class="dot"></li>
            <li class="dot"></li>
            <li class="dot"></li>
          </ol>
        </div>

        <div class="nav-buttons">
          <a class="chip dark" href="#intro" role="button">Intro</a>
          <a class="chip primary next-btn" href="#quiz2" role="button">Next</a>
        </div>
      </div>
    </div>
  </section>

  <!-- =========================
       Q2 — (multi) — Section 1 (50%) — Grid-4
       ========================= -->
  <section id="quiz2"
           class="quiz-section q2 quiz-section--grid-4 multi-select"
           aria-labelledby="q2-title">
    <div class="quiz-wrap">
      <div class="quiz-top">
        <div class="quiz-title">
          <h2 id="q2-title">Q2. How do you want people to perceive you?</h2>
          <p class="note">(You can select more than one if it applies)</p>
        </div>
      </div>

      <div class="quiz-stage">
        <div class="options">
          <!-- 1) Confident — Style Rebel +3, Street Muse +1 -->
          <label class="option">
            <input type="checkbox" class="check"
                   data-street_muse="1"
                   data-style_rebel="3"
                   data-effortlessly_polished="0"
                   data-romantic_dreamer="0" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/quiz/quiz-outfits/quiz-style-rebel-6.jpg"
                   alt="quiz-style-rebel statement look" loading="lazy" decoding="async" width="520" height="700"/>
            </span>
            <span class="opt-label">Confident</span>
          </label>

          <!-- 2) Creative -->
          <label class="option">
            <input type="checkbox" class="check"
                   data-street_muse="1"
                   data-style_rebel="3"
                   data-effortlessly_polished="0"
                   data-romantic_dreamer="0" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/quiz/quiz-outfits/quiz-style-rebel-5.jpg"
                   alt="quiz-style-rebel statement look" loading="lazy" decoding="async" width="520" height="700"/>
            </span>
            <span class="opt-label">Creative</span>
          </label>

          <!-- 3) Sophisticated -->
          <label class="option">
            <input type="checkbox" class="check"
                   data-street_muse="0"
                   data-style_rebel="0"
                   data-effortlessly_polished="3"
                   data-romantic_dreamer="1" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/quiz/quiz-outfits/quiz-effortlessly-polished-5.jpg"
                   alt="quiz-effortlessly-polished statement look" loading="lazy" decoding="async" width="520" height="700"/>
            </span>
            <span class="opt-label">Sophisticated</span>
          </label>

          <!-- 4) Graceful & Vintage -->
          <label class="option">
            <input type="checkbox" class="check"
                   data-street_muse="0"
                   data-style_rebel="0"
                   data-effortlessly_polished="1"
                   data-romantic_dreamer="3" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/quiz/quiz-outfits/quiz-romantic-dreamer-1.jpg"
                   alt="quiz-romantic-dreamer Everyday" loading="lazy" decoding="async" width="520" height="700"/>
            </span>
            <span class="opt-label">Graceful &amp; Vintage</span>
          </label>
        </div>
      </div>

      <div class="quiz-bottom">
        <div class="progress">
          <div class="progress-label" aria-live="off">Section 1 of 5</div>
          <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-current" style="--fill:50%;" aria-current="step"></li>
            <li class="dot"></li>
            <li class="dot"></li>
            <li class="dot"></li>
            <li class="dot"></li>
          </ol>
        </div>
        <div class="nav-buttons">
          <a class="chip dark"    href="#quiz1" role="button">Previous</a>
          <a class="chip primary next-btn" href="#quiz3" role="button">Next</a>
        </div>
      </div>
    </div>
  </section>

  <!-- =========================
       Q3 — Multi (max 2) — Section 1 (75%)
       ========================= -->
  <section id="quiz3"
           class="quiz-section q3 quiz-section--grid-4 multi-select"
           aria-labelledby="q3-title"
           data-max-select="2">
    <div class="quiz-wrap">
      <div class="quiz-top">
        <div class="quiz-title">
          <h2 id="q3-title">Q3. Your outfit should make you feel…?</h2>
          <p class="note">(Pick up to two answers that best fits)</p>
        </div>
      </div>

      <div class="quiz-stage">
        <div class="options">
          <!-- 1) Empowered -->
          <label class="option">
            <input type="checkbox" class="check"
                   data-street_muse="1"
                   data-style_rebel="3"
                   data-effortlessly_polished="0"
                   data-romantic_dreamer="0" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/quiz/quiz-outfits/quiz-style-rebel-6.jpg"
                   alt="Style Rebel Statement Look" loading="lazy" decoding="async" width="520" height="700"/>
            </span>
            <span class="opt-label">Empowered</span>
          </label>

          <!-- 2) Comfortable -->
          <label class="option">
            <input type="checkbox" class="check"
                   data-street_muse="3"
                   data-style_rebel="0"
                   data-effortlessly_polished="1"
                   data-romantic_dreamer="0" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/quiz/quiz-outfits/quiz-street-muse-1.jpg"
                   alt="quiz-street-muse Everyday" loading="lazy" decoding="async" width="520" height="700" />
            </span>
            <span class="opt-label">Comfortable</span>
          </label>

          <!-- 3) Trendy -->
          <label class="option">
            <input type="checkbox" class="check"
                   data-street_muse="3"
                   data-style_rebel="1"
                   data-effortlessly_polished="0"
                   data-romantic_dreamer="0" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/quiz/quiz-outfits/quiz-street-muse-6.jpg"
                   alt="Street Muse Statement Look" loading="lazy" decoding="async" width="520" height="700" />
            </span>
            <span class="opt-label">Trendy</span>
          </label>

          <!-- 4) Romantic -->
          <label class="option">
            <input type="checkbox" class="check"
                   data-street_muse="0"
                   data-style_rebel="0"
                   data-effortlessly_polished="1"
                   data-romantic_dreamer="3" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/quiz/quiz-outfits/quiz-romantic-dreamer-5.jpg"
                   alt="quiz-romantic-dreamer Statement Look" loading="lazy" decoding="async" width="520" height="700" />
            </span>
            <span class="opt-label">Romantic</span>
          </label>
        </div>
      </div>

      <div class="quiz-bottom">
        <div class="progress">
          <div class="progress-label" aria-live="off">Section 1 of 5</div>
          <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-current" style="--fill:75%;" aria-current="step"></li>
            <li class="dot"></li>
            <li class="dot"></li>
            <li class="dot"></li>
            <li class="dot"></li>
          </ol>
        </div>
        <div class="nav-buttons">
          <a class="chip dark"    href="#quiz2" role="button">Previous</a>
          <a class="chip primary next-btn" href="#quiz4" role="button">Next</a>
        </div>
      </div>
    </div>
  </section>

  <!-- =========================
       Q4 — Single — Quotes — Section 1 (100%)
       ========================= -->
  <section id="quiz4"
           class="quiz-section q4 quiz-section--quotes single-select"
           data-max-select="1"
           aria-labelledby="q4-title">
    <div class="quiz-wrap">
      <div class="quiz-top">
        <div class="quiz-title">
          <h2 id="q4-title">Q4. Which quote about fashion speaks to you?</h2>
          <p class="note">(Pick one answer that best fits)</p>
        </div>
      </div>

      <div class="quiz-stage">
        <div class="options">
          <!-- 1) Rihanna -->
          <label class="quote-option">
            <input type="radio" name="q4" class="radio"
                   data-street_muse="1"
                   data-style_rebel="3"
                   data-effortlessly_polished="0"
                   data-romantic_dreamer="0" />
            <span class="quote-card">
              <span class="quote-text">"There's freedom in wearing what reflects your spirit." – Rihanna</span>
              <span class="quote-badge" aria-hidden="true"></span>
            </span>
          </label>

          <!-- 2) Zendaya -->
          <label class="quote-option">
            <input type="radio" name="q4" class="radio"
                   data-street_muse="0"
                   data-style_rebel="0"
                   data-effortlessly_polished="3"
                   data-romantic_dreamer="1" />
            <span class="quote-card">
              <span class="quote-text">"Less can say more when you focus on the right details." – Zendaya</span>
              <span class="quote-badge" aria-hidden="true"></span>
            </span>
          </label>

          <!-- 3) Meghan Markle -->
          <label class="quote-option">
            <input type="radio" name="q4" class="radio"
                   data-street_muse="0"
                   data-style_rebel="0"
                   data-effortlessly_polished="3"
                   data-romantic_dreamer="1" />
            <span class="quote-card">
              <span class="quote-text">"True elegance is being remembered for your presence, not just your outfit." – Meghan Markle</span>
              <span class="quote-badge" aria-hidden="true"></span>
            </span>
          </label>

          <!-- 4) Florence Pugh -->
          <label class="quote-option">
            <input type="radio" name="q4" class="radio"
                   data-street_muse="0"
                   data-style_rebel="0"
                   data-effortlessly_polished="1"
                   data-romantic_dreamer="3" />
            <span class="quote-card">
              <span class="quote-text">"I love that fashion can be like armor, but also like a fairytale." – Florence Pugh</span>
              <span class="quote-badge" aria-hidden="true"></span>
            </span>
          </label>
        </div>
      </div>

      <div class="quiz-bottom">
        <div class="progress">
          <div class="progress-label" aria-live="off">Section 1 of 5</div>
          <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-current" style="--fill:100%;" aria-current="step"></li>
            <li class="dot"></li>
            <li class="dot"></li>
            <li class="dot"></li>
            <li class="dot"></li>
          </ol>
        </div>
        <div class="nav-buttons">
          <a class="chip dark"    href="#quiz3" role="button">Previous</a>
          <a class="chip primary next-btn" href="#quiz5" role="button">Next</a>
        </div>
      </div>
    </div>
  </section>

  <!-- =========================
       Q5 — Multi — Section 2 (16.7%)
       ========================= -->
  <section id="quiz5"
           class="quiz-section q5 quiz-section--grid-4 multi-select"
           data-max-select=""
           aria-labelledby="q5-title">
    <div class="quiz-wrap">
      <div class="quiz-top">
        <div class="quiz-title">
          <h2 id="q5-title">Q5. Pick all that match your fashion goals.</h2>
          <p class="note">(You can select more than one if it applies)</p>
        </div>
      </div>

      <div class="quiz-stage">
        <div class="options">
          <!-- 1) Stand out -->
          <label class="option">
            <input type="checkbox" class="check"
                   data-street_muse="1"
                   data-style_rebel="3"
                   data-effortlessly_polished="0"
                   data-romantic_dreamer="0" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/quiz/quiz-outfits/quiz-style-rebel-5.jpg"
                   alt="quiz-style-rebel statement look" loading="lazy" decoding="async" width="520" height="700"/>
            </span>
            <span class="opt-label">Stand out</span>
          </label>

          <!-- 2) Stay comfortable -->
          <label class="option">
            <input type="checkbox" class="check"
                   data-street_muse="3"
                   data-style_rebel="0"
                   data-effortlessly_polished="1"
                   data-romantic_dreamer="0" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/quiz/quiz-outfits/quiz-street-muse-2.jpg"
                   alt="Street Muse Everyday Look" loading="lazy" decoding="async" width="520" height="700"/>
            </span>
            <span class="opt-label">Stay comfortable</span>
          </label>

          <!-- 3) Follow trends -->
          <label class="option">
            <input type="checkbox" class="check"
                   data-street_muse="3"
                   data-style_rebel="1"
                   data-effortlessly_polished="0"
                   data-romantic_dreamer="0" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/quiz/quiz-outfits/quiz-street-muse-5.jpg"
                   alt="Street Muse Statement Look" loading="lazy" decoding="async" width="520" height="700"/>
            </span>
            <span class="opt-label">Follow trends</span>
          </label>

          <!-- 4) Embrace timeless elegance -->
          <label class="option">
            <input type="checkbox" class="check"
                   data-street_muse="0"
                   data-style_rebel="0"
                   data-effortlessly_polished="1"
                   data-romantic_dreamer="3" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/quiz/quiz-outfits/quiz-romantic-dreamer-3.jpg"
                   alt="quiz-romantic-dreamer Career Wear" loading="lazy" decoding="async" width="520" height="700"/>
            </span>
            <span class="opt-label">Embrace timeless elegance</span>
          </label>
        </div>
      </div>

      <div class="quiz-bottom">
        <div class="progress">
          <div class="progress-label" aria-live="off">Section 2 of 5</div>
          <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-complete"></li>
            <li class="dot is-current" style="--fill:16.7%;" aria-current="step"></li>
            <li class="dot"></li>
            <li class="dot"></li>
            <li class="dot"></li>
          </ol>
        </div>
        <div class="nav-buttons">
          <a class="chip dark"    href="#quiz4" role="button">Previous</a>
          <a class="chip primary next-btn" href="#quiz6" role="button">Next</a>
        </div>
      </div>
    </div>
  </section>

  <!-- =========================
       Q6 — Lookboard (single-select)
       ========================= -->
  <section id="quiz6"
           class="quiz-section q6 quiz-section--lookboard single-select"
           data-max-select="1"
           aria-labelledby="q6-title">
    <div class="quiz-wrap">
      <div class="quiz-top">
        <div class="quiz-title">
          <h2 id="q6-title">Q6. How would you infuse your personal charm into a basic outfit?</h2>
          <p class="note">(Pick one answer that best fits)</p>
        </div>
      </div>

      <div class="quiz-stage">
        <div class="lookboard">
          <!-- Reference look (NOT selectable) -->
          <figure class="ref-look" aria-hidden="true">
            <div class="ref-frame">
              <div class="ref-canvas">
                <img
                  src="./assets/images/quiz/quiz-outfits/base-outfit-1.jpg"
                  alt="Base outfit"
                  loading="lazy" decoding="async" width="900" height="1200"
                />
              </div>
            </div>
          </figure>

          <!-- Answers (radios) -->
          <div class="options">
            <!-- 1 -->
            <label class="option opt-1">
              <input type="radio" name="q6" class="radio"
                     data-street_muse="3" data-style_rebel="1"
                     data-effortlessly_polished="0" data-romantic_dreamer="0" />
              <span class="tile">
                <span class="badge" aria-hidden="true"></span>
                <img src="./assets/images/clothing-purchase/style-rebel-purchase/statememt/statement-look-fit-2-jacket.webp" alt="leather brown jacket" loading="lazy" decoding="async" width="600" height="800"/>
              </span>
              <span class="opt-label">Statement jacket</span>
            </label>

            <!-- 2 -->
            <label class="option opt-2">
              <input type="radio" name="q6" class="radio"
                     data-street_muse="1" data-style_rebel="3"
                     data-effortlessly_polished="0" data-romantic_dreamer="0" />
              <span class="tile">
                <span class="badge" aria-hidden="true"></span>
                <img src="./assets/images/clothing-purchase/style-rebel-purchase/statememt/statement-look-fit-1-shoes.webp" alt="" loading="lazy" decoding="async" width="600" height="800"/>
              </span>
              <span class="opt-label">Swap for bold shoes</span>
            </label>

            <!-- 3 -->
            <label class="option opt-3">
              <input type="radio" name="q6" class="radio"
                     data-street_muse="0" data-style_rebel="0"
                     data-effortlessly_polished="3" data-romantic_dreamer="1" />
              <span class="tile">
                <span class="badge" aria-hidden="true"></span>
                <img src="./assets/images/clothing-purchase/style-rebel-purchase/everyday/everyday-fit-2-purse.webp" alt="" loading="lazy" decoding="async" width="520" height="700"/>
              </span>
              <span class="opt-label">Add a chic accessory</span>
            </label>

            <!-- 4 -->
            <label class="option opt-4">
              <input type="radio" name="q6" class="radio"
                     data-street_muse="0" data-style_rebel="0"
                     data-effortlessly_polished="1" data-romantic_dreamer="3" />
              <span class="tile">
                <span class="badge" aria-hidden="true"></span>
                <img src="./assets/images/quiz/quiz-outfits/lace-top.png" alt="long lace top" loading="lazy" decoding="async" width="520" height="700"/>
              </span>
              <span class="opt-label">Layer with a delicate lace piece</span>
            </label>
          </div>
        </div>
      </div>

      <div class="quiz-bottom">
        <div class="progress">
          <div class="progress-label" aria-live="off">Section 2 of 5</div>
          <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-complete"></li>
            <li class="dot is-current" style="--fill:33.3%;" aria-current="step"></li>
            <li class="dot"></li>
            <li class="dot"></li>
            <li class="dot"></li>
          </ol>
        </div>
        <div class="nav-buttons">
          <a class="chip dark" href="#quiz5" role="button">Previous</a>
          <a class="chip primary next-btn" href="#quiz7" role="button">Next</a>
        </div>
      </div>
    </div>
  </section>


<!-- =========================
     Q7 — Lookboard (single-select) (50%)
     ========================= -->
<section id="quiz7"
         class="quiz-section q7 quiz-section--lookboard single-select"
         data-max-select="1"
         aria-labelledby="q7-title">
  <div class="quiz-wrap">
    <div class="quiz-top">
      <div class="quiz-title">
        <h2 id="q7-title">Q7. Pick the shoes that would complete this look</h2>
        <p class="note">(Pick one answer that best fits)</p>
      </div>
    </div>

    <div class="quiz-stage">
      <div class="lookboard">
        <!-- Reference look (NOT selectable) -->
        <figure class="ref-look" aria-hidden="true">
          <div class="ref-frame">
            <div class="ref-canvas">
              <img
                src="./assets/images/quiz/quiz-outfits/base-look-2.jpg"
                alt="black top black pants base"
                loading="lazy" decoding="async" width="520" height="700"
              />
            </div>
          </div>
        </figure>

        <!-- Answers (radios) -->
        <div class="options">
          <!-- 1) Ankle boots — Street Muse +3, Style Rebel +1 -->
          <label class="option opt-1">
            <input type="radio" name="q7" class="radio"
                   data-street_muse="3" data-style_rebel="1"
                   data-effortlessly_polished="0" data-romantic_dreamer="0" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/clothing-purchase/style-rebel-purchase/career-wear/careerwear-fit-3-shoes.webp"
                   alt="" loading="lazy" decoding="async" width="520" height="700"/>
            </span>
            <span class="opt-label">Ankle boots</span>
          </label>

          <!-- 2) Sneakers — Street Muse +3, Effortlessly Polished +1 -->
          <label class="option opt-2">
            <input type="radio" name="q7" class="radio"
                   data-street_muse="3" data-style_rebel="0"
                   data-effortlessly_polished="1" data-romantic_dreamer="0" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/clothing-purchase/street-muse-purchase/career-wear/careerwear-fit-2-shoes.webp"
                   alt="blacksneaker shoes" loading="lazy" decoding="async" width="520" height="700"/>
            </span>
            <span class="opt-label">Sneakers</span>
          </label>

          <!-- 3) Heels — Effortlessly Polished +3, Style Rebel +1 -->
          <label class="option opt-3">
            <input type="radio" name="q7" class="radio"
                   data-street_muse="0" data-style_rebel="1"
                   data-effortlessly_polished="3" data-romantic_dreamer="0" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/clothing-purchase/romantic-dreamer-purchase/statememt/statement-look-fit-2-shoes.webp"
                   alt="black heels" loading="lazy" decoding="async" width="520" height="700"/>
            </span>
            <span class="opt-label">Heels</span>
          </label>

          <!-- 4) Ballet flats — Romantic Dreamer +3, Effortlessly Polished +1 -->
          <label class="option opt-4">
            <input type="radio" name="q7" class="radio"
                   data-street_muse="0" data-style_rebel="0"
                   data-effortlessly_polished="1" data-romantic_dreamer="3" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/clothing-purchase/romantic-dreamer-purchase/career-wear/careerwear-fit-3-shoes.webp"
                   alt="brown red flat shoes" loading="lazy" decoding="async" width="520" height="700"/>
            </span>
            <span class="opt-label">Ballet flats</span>
          </label>
        </div>
      </div>
    </div>

    <div class="quiz-bottom">
      <div class="progress">
        <div class="progress-label" aria-live="off">Section 2 of 5</div>
        <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-complete"></li>
            <li class="dot is-current" style="--fill:50%;" aria-current="step"></li>
            <li class="dot"></li>
            <li class="dot"></li>
            <li class="dot"></li>
          </ol>
      </div>
      <div class="nav-buttons">
        <a class="chip dark" href="#quiz6" role="button">Previous</a>
        <a class="chip primary next-btn" href="#quiz8" role="button">Next</a>
      </div>
    </div>
  </div>
</section>


<!-- =========================
     Q8 — Single (grid-4) — Section 2 (66.7%)
     ========================= -->
<section id="quiz8"
         class="quiz-section q8 quiz-section--grid-4 single-select"
         data-max-select="1"
         aria-labelledby="q8-title">
  <div class="quiz-wrap">
    <div class="quiz-top">
      <div class="quiz-title">
        <h2 id="q8-title">Q8. Choose your favorite version of this jacket</h2>
        <p class="note">(Pick one answer that best fits)</p>
      </div>
      <div class="step">Section 2 of 5</div>
    </div>

    <div class="quiz-stage">
      <div class="options">
        <!-- Leather jacket — Street Muse +3, Style Rebel +1 -->
        <label class="option">
          <input type="radio" name="q8" class="radio"
                 data-street_muse="3"
                 data-style_rebel="1"
                 data-effortlessly_polished="0"
                 data-romantic_dreamer="0" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/clothing-purchase/style-rebel-purchase/everyday/everyday-fit-2-jacket.webp"
                 alt="leather jacket" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Leather jacket</span>
        </label>

        <!-- Denim jacket — Street Muse +3, Romantic Dreamer +1 -->
        <label class="option">
          <input type="radio" name="q8" class="radio"
                 data-street_muse="3"
                 data-style_rebel="0"
                 data-effortlessly_polished="0"
                 data-romantic_dreamer="1" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/clothing-purchase/style-rebel-purchase/career-wear/careerwear-fit-3-jacket.webp"
                 alt="Denim jacket" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Denim jacket</span>
        </label>

        <!-- Trench coat — Effortlessly Polished +3, Romantic Dreamer +1 -->
        <label class="option">
          <input type="radio" name="q8" class="radio"
                 data-street_muse="0"
                 data-style_rebel="0"
                 data-effortlessly_polished="3"
                 data-romantic_dreamer="1" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/clothing-purchase/effortlessly-polished-purchase/statememt/statement-look-fit-2-coat.webp"
                 alt="Trench coat" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Trench coat</span>
        </label>

        <!-- Floral lace jacket — Romantic Dreamer +3, Effortlessly Polished +1 -->
        <label class="option">
          <input type="radio" name="q8" class="radio"
                 data-street_muse="0"
                 data-style_rebel="0"
                 data-effortlessly_polished="1"
                 data-romantic_dreamer="3" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/quiz/quiz-outfits/lace-jean-jacket.png"
                 alt="Jean lace jacket" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Floral lace jacket</span>
        </label>
      </div>
    </div>

    <div class="quiz-bottom">
      <div class="progress">
        <div class="progress-label" aria-live="off">Section 2 of 5</div>
        <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-complete"></li>
            <li class="dot is-current" style="--fill:66.7%;" aria-current="step"></li>
            <li class="dot"></li>
            <li class="dot"></li>
            <li class="dot"></li>
          </ol>
      </div>
      <div class="nav-buttons">
        <a class="chip dark" href="#quiz7" role="button">Previous</a>
        <a class="chip primary next-btn" href="#quiz9" role="button">Next</a>
      </div>
    </div>
  </div> 
</section>

  <!-- =========================
       Q9 — Single — Section 2 (83.3%)
       ========================= -->
<section id="quiz9"
         class="quiz-section q9 quiz-section--lookboard single-select"
         data-max-select="1"
         aria-labelledby="q9-title">
  <div class="quiz-wrap">
    <div class="quiz-top">
      <div class="quiz-title">
        <h2 id="q9-title">Q9. Pick a bag to finish the look</h2>
        <p class="note">(Pick one answer that best fits)</p>
      </div>
      <div class="step">Section 2 of 5</div>
    </div>

    <div class="quiz-stage">
      <div class="lookboard">
        <!-- Reference look (NOT selectable) -->
        <figure class="ref-look" aria-hidden="true">
          <div class="ref-frame">
            <div class="ref-canvas">
              <img
                src="./assets/images/quiz/quiz-outfits/base-look-3.jpg"
                alt=""
                loading="lazy" decoding="async" width="520" height="700"
              />
            </div>
          </div>
        </figure>

        <!-- Answers (radios) -->
        <div class="options">
          <!-- 1) Crossbody bag — Street Muse +3, Effortlessly Polished +1 -->
          <label class="option opt-1">
            <input type="radio" name="q9" class="radio"
                   data-street_muse="3" data-style_rebel="0"
                   data-effortlessly_polished="1" data-romantic_dreamer="0" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/quiz/quiz-outfits/crossbody-bag.png"
                   alt="Crossbody bag" loading="lazy" decoding="async" width="520" height="700"/>
            </span>
            <span class="opt-label">Crossbody bag</span>
          </label>

          <!-- 2) Tote — Effortlessly Polished +3, Street Muse +1 -->
          <label class="option opt-2">
            <input type="radio" name="q9" class="radio"
                   data-street_muse="1" data-style_rebel="0"
                   data-effortlessly_polished="3" data-romantic_dreamer="0" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/quiz/quiz-outfits/tote.png"
                   alt="tote bag" loading="lazy" decoding="async" width="520" height="700"/>
            </span>
            <span class="opt-label">Tote</span>
          </label>

          <!-- 3) Clutch — Effortlessly Polished +3, Romantic Dreamer +1 -->
          <label class="option opt-3">
            <input type="radio" name="q9" class="radio"
                   data-street_muse="0" data-style_rebel="0"
                   data-effortlessly_polished="3" data-romantic_dreamer="1" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/quiz/quiz-outfits/clutch.png"
                   alt="burgundy pearl clutch bag" loading="lazy" decoding="async" width="520" height="700"/>
            </span>
            <span class="opt-label">Clutch</span>
          </label>

          <!-- 4) Woven vintage bag — Romantic Dreamer +3, Effortlessly Polished +1 -->
          <label class="option opt-4">
            <input type="radio" name="q9" class="radio"
                   data-street_muse="0" data-style_rebel="0"
                   data-effortlessly_polished="1" data-romantic_dreamer="3" />
            <span class="tile">
              <span class="badge" aria-hidden="true"></span>
              <img src="./assets/images/quiz/quiz-outfits/woven-vintage.png"
                   alt="dark brown Woven vintage bag" loading="lazy" decoding="async" width="520" height="700"/>
            </span>
            <span class="opt-label">Woven vintage bag</span>
          </label>
        </div>
      </div>
    </div>

    <div class="quiz-bottom">
      <div class="progress">
        <div class="progress-label" aria-live="off">Section 2 of 5</div>
        <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-complete"></li>
            <li class="dot is-current" style="--fill:83.3%;" aria-current="step"></li>
            <li class="dot"></li>
            <li class="dot"></li>
            <li class="dot"></li>
          </ol>
      </div>
      <div class="nav-buttons">
        <a class="chip dark" href="#quiz8" role="button">Previous</a>
        <a class="chip primary next-btn" href="#quiz10" role="button">Next</a>
      </div>
    </div>
  </div>
</section>


<!-- =========================
     Q10 — Single (grid-4) — Section 2 (100%)
     ========================= -->
<section id="quiz10"
         class="quiz-section q10 quiz-section--grid-4 single-select"
         aria-labelledby="q10-title">
  <div class="quiz-wrap">
    <div class="quiz-top">
      <div class="quiz-title">
        <h2 id="q10-title">Q10. Choose the outfit that feels like you</h2>
        <p class="note">(Pick one answer that best fits)</p>
      </div>
      <div class="step">Section 2 of 5</div>
    </div>

    <div class="quiz-stage">
      <div class="options">
        <!-- 1) Casual dress — Street Muse +3, Romantic Dreamer +1 -->
        <label class="option">
          <input type="radio" name="q10" class="radio"
                 data-street_muse="3" data-style_rebel="0"
                 data-effortlessly_polished="0" data-romantic_dreamer="1" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/quiz/quiz-outfits/quiz-street-muse-2.jpg"
                 alt="quiz-street-muse everyday" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Casual dress</span>
        </label>

        <!-- 2) Leather jacket + jeans — Street Muse +3, Style Rebel +1 -->
        <label class="option">
          <input type="radio" name="q10" class="radio"
                 data-street_muse="3" data-style_rebel="1"
                 data-effortlessly_polished="0" data-romantic_dreamer="0" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/quiz/quiz-outfits/leather-pants.png"
                 alt="quiz-street-muse statement look" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Leather jacket + jeans</span>
        </label>

        <!-- 3) Blazer set — Effortlessly Polished +3, Romantic Dreamer +1 -->
        <label class="option">
          <input type="radio" name="q10" class="radio"
                 data-street_muse="0" data-style_rebel="0"
                 data-effortlessly_polished="3" data-romantic_dreamer="1" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/quiz/quiz-outfits/blazer-set.png"
                 alt="Blazer Set" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Blazer set</span>
        </label>

        <!-- 4) Lace floral dress — Romantic Dreamer +3, Effortlessly Polished +1 -->
        <label class="option">
          <input type="radio" name="q10" class="radio"
                 data-street_muse="0" data-style_rebel="0"
                 data-effortlessly_polished="1" data-romantic_dreamer="3" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/quiz/quiz-outfits/lace-floral-dress.png"
                 alt="White Lace Floral dress" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Lace floral dress</span>
        </label>
      </div>
    </div>

    <div class="quiz-bottom">
      <div class="progress">
        <div class="progress-label" aria-live="off">Section 2 of 5</div>
        <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-complete"></li>
            <li class="dot is-current" style="--fill:100%;" aria-current="step"></li>
            <li class="dot"></li>
            <li class="dot"></li>
            <li class="dot"></li>
          </ol>
      </div>
      <div class="nav-buttons">
        <a class="chip dark" href="#quiz9" role="button">Previous</a>
        <a class="chip primary next-btn" href="#quiz11" role="button">Next</a>
      </div>
    </div>
  </div>
</section>

 <!-- =========================
     Q11 — Multi (quotes) — Section 3 (25%)
     ========================= -->
<section id="quiz11"
         class="quiz-section q11 quiz-section--quotes multi-select"
         aria-labelledby="q11-title">
  <div class="quiz-wrap">
    <div class="quiz-top">
      <div class="quiz-title">
        <h2 id="q11-title">Q11. Where do you usually go in your favorite outfits</h2>
        <p class="note">(You can select more than one if it applies)</p>
      </div>
      <div class="step">Section 3 of 5</div>
    </div>

    <div class="quiz-stage">
      <div class="options">
        <!-- Work — Effortlessly Polished +3, Street Muse +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="1" data-style_rebel="0"
                 data-effortlessly_polished="3" data-romantic_dreamer="0" />
          <span class="quote-card">
            <span class="quote-text">Work</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- Café — Street Muse +3, Effortlessly Polished +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="3" data-style_rebel="0"
                 data-effortlessly_polished="1" data-romantic_dreamer="0" />
          <span class="quote-card">
            <span class="quote-text">Café</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- Party — Street Muse +3, Style Rebel +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="3" data-style_rebel="1"
                 data-effortlessly_polished="0" data-romantic_dreamer="0" />
          <span class="quote-card">
            <span class="quote-text">Party</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- Garden stroll — Romantic Dreamer +3, Effortlessly Polished +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="0" data-style_rebel="0"
                 data-effortlessly_polished="1" data-romantic_dreamer="3" />
          <span class="quote-card">
            <span class="quote-text">Garden stroll</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- Pop event — Style Rebel +3, Street Muse +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="1" data-style_rebel="3"
                 data-effortlessly_polished="0" data-romantic_dreamer="0" />
          <span class="quote-card">
            <span class="quote-text">Pop event</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>
      </div>
    </div>

    <div class="quiz-bottom">
      <div class="progress">
        <div class="progress-label" aria-live="off">Section 3 of 5</div>
        <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-complete"></li>
            <li class="dot is-complete"></li>
            <li class="dot is-current" style="--fill:25%;" aria-current="step"></li>
            <li class="dot"></li>
            <li class="dot"></li>
          </ol>
      </div>
      <div class="nav-buttons">
        <a class="chip dark" href="#quiz10" role="button">Previous</a>
        <a class="chip primary next-btn" href="#quiz12" role="button">Next</a>
      </div>
    </div>
  </div>
</section>

<!-- =========================
     Q12 — Multi (quotes) — Section 3 (50%)
     ========================= -->
<section id="quiz12"
         class="quiz-section q12 quiz-section--quotes multi-select"
         aria-labelledby="q12-title">
  <div class="quiz-wrap">
    <div class="quiz-top">
      <div class="quiz-title">
        <h2 id="q12-title">Q12. Pick events you regularly need outfits for</h2>
        <p class="note">(You can select more than one if it applies)</p>
      </div>
      <div class="step">Section 3 of 5</div>
    </div>

    <div class="quiz-stage">
      <div class="options">
        <!-- Wedding — Romantic Dreamer +3, Effortlessly Polished +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="0" data-style_rebel="0"
                 data-effortlessly_polished="1" data-romantic_dreamer="3" />
          <span class="quote-card">
            <span class="quote-text">Wedding</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- Meeting — Effortlessly Polished +3, Romantic Dreamer +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="0" data-style_rebel="0"
                 data-effortlessly_polished="3" data-romantic_dreamer="1" />
          <span class="quote-card">
            <span class="quote-text">Meeting</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- Date — Street Muse +3, Romantic Dreamer +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="3" data-style_rebel="0"
                 data-effortlessly_polished="0" data-romantic_dreamer="1" />
          <span class="quote-card">
            <span class="quote-text">Date</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- Picnic — Romantic Dreamer +3, Street Muse +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="1" data-style_rebel="0"
                 data-effortlessly_polished="0" data-romantic_dreamer="3" />
          <span class="quote-card">
            <span class="quote-text">Picnic</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>
      </div>
    </div>

    <div class="quiz-bottom">
      <div class="progress">
        <div class="progress-label" aria-live="off">Section 3 of 5</div>
        <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-complete"></li>
            <li class="dot is-complete"></li>
            <li class="dot is-current" style="--fill:50%;" aria-current="step"></li>
            <li class="dot"></li>
            <li class="dot"></li>
          </ol>
      </div>
      <div class="nav-buttons">
        <a class="chip dark" href="#quiz11" role="button">Previous</a>
        <a class="chip primary next-btn" href="#quiz13" role="button">Next</a>
      </div>
    </div>
  </div>
</section>
<!-- =========================
     Q13 — Single — Section 3 (75%) — Grid-4 like Q1
     ========================= -->
<section id="quiz13"
         class="quiz-section q13 quiz-section--grid-4 single-select"
         aria-labelledby="q13-title">
  <div class="quiz-wrap">
    <div class="quiz-top">
      <div class="quiz-title">
        <h2 id="q13-title">Q13. What's your go-to casual day outfit</h2>
        <p class="note">(Pick one answer that best fits)</p>
      </div>
      <div class="step">Section 3 of 5</div>
    </div>

    <div class="quiz-stage">
      <div class="options">
        <!-- 1) T-shirt + jeans — Street Muse +3, Effortlessly Polished +1 -->
        <label class="option">
          <input type="radio" name="q13" class="radio"
                 data-street_muse="3" data-style_rebel="0"
                 data-effortlessly_polished="1" data-romantic_dreamer="0" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/outfits/street-muse/everyday/ed-outfit-2.webp" alt="T-shirt  jeans look" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">T-shirt + jeans</span>
        </label>

        <!-- 2) Sweater + Pants — Effortlessly Polished +3, Street Muse +1 -->
        <label class="option">
          <input type="radio" name="q13" class="radio"
                 data-street_muse="1" data-style_rebel="0"
                 data-effortlessly_polished="3" data-romantic_dreamer="0" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/quiz/quiz-outfits/quiz-effortlessly-polished-3.jpg" alt="Sweater and Pants" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Sweater + Pants</span>
        </label>

        <!-- 3) Lace top + flowing skirt — Romantic Dreamer +3, Effortlessly Polished +1 -->
        <label class="option">
          <input type="radio" name="q13" class="radio"
                 data-street_muse="0" data-style_rebel="0"
                 data-effortlessly_polished="1" data-romantic_dreamer="3" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/quiz/quiz-outfits/quiz-romantic-dreamer-4.jpg" alt="Top and flowing skirt while reading" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Top + flowing skirt</span>
        </label>
      </div>
    </div>

    <div class="quiz-bottom">
      <div class="progress">
        <div class="progress-label" aria-live="off">Section 3 of 5</div>
        <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-complete"></li>
            <li class="dot is-complete"></li>
            <li class="dot is-current" style="--fill:75%;" aria-current="step"></li>
            <li class="dot"></li>
            <li class="dot"></li>
          </ol>
      </div>
      <div class="nav-buttons">
        <a class="chip dark" href="#quiz12" role="button">Previous</a>
        <a class="chip primary next-btn" href="#quiz14" role="button">Next</a>
      </div>
    </div>
  </div>
</section>


 <!-- =========================
     Q14 — Multi — Section 3 (100%) — quotes style
     ========================= -->
<section id="quiz14"
         class="quiz-section q14 quiz-section--quotes multi-select"
         aria-labelledby="q14-title">
  <div class="quiz-wrap">
    <div class="quiz-top">
      <div class="quiz-title">
        <h2 id="q14-title">Q14. What does a regular week look like</h2>
        <p class="note">(You can select more than one if it applies)</p>
      </div>
      <div class="step">Section 3 of 5</div>
    </div>

    <div class="quiz-stage">
      <div class="options">
        <!-- Work — EP +3, SM +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="1" data-style_rebel="0"
                 data-effortlessly_polished="3" data-romantic_dreamer="0" />
          <span class="quote-card">
            <span class="quote-text">Work</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- Social — SM +3, SR +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="3" data-style_rebel="1"
                 data-effortlessly_polished="0" data-romantic_dreamer="0" />
          <span class="quote-card">
            <span class="quote-text">Social</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- Gym — SR +3, SM +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="1" data-style_rebel="3"
                 data-effortlessly_polished="0" data-romantic_dreamer="0" />
          <span class="quote-card">
            <span class="quote-text">Gym</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- Visit a museum — RD +3, EP +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="0" data-style_rebel="0"
                 data-effortlessly_polished="1" data-romantic_dreamer="3" />
          <span class="quote-card">
            <span class="quote-text">Visit a museum</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>
      </div>
    </div>

    <div class="quiz-bottom">
      <div class="progress">
        <div class="progress-label" aria-live="off">Section 3 of 5</div>
        <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-complete"></li>
            <li class="dot is-complete"></li>
            <li class="dot is-current" style="--fill:100%;" aria-current="step"></li>
            <li class="dot"></li>
            <li class="dot"></li>
          </ol>
      </div>
      <div class="nav-buttons">
        <a class="chip dark" href="#quiz13" role="button">Previous</a>
        <a class="chip primary next-btn" href="#quiz15" role="button">Next</a>
      </div>
    </div>
  </div>
</section>

<!-- =========================
     Q15 — Multi — Section 4 (25%) — quotes style
     ========================= -->
<section id="quiz15"
         class="quiz-section q15 quiz-section--quotes multi-select"
         aria-labelledby="q15-title">
  <div class="quiz-wrap">
    <div class="quiz-top">
      <div class="quiz-title">
        <h2 id="q15-title">Q15. Where do you find your fashion inspo</h2>
        <p class="note">(You can select more than one if it applies)</p>
      </div>
      <div class="step">Section 4 of 5</div>
    </div>

    <div class="quiz-stage">
      <div class="options">
        <!-- Instagram — SM +3, SR +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="3" data-style_rebel="1"
                 data-effortlessly_polished="0" data-romantic_dreamer="0" />
          <span class="quote-card">
            <span class="quote-text">Instagram</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- Pinterest — SR +3, RD +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="0" data-style_rebel="3"
                 data-effortlessly_polished="0" data-romantic_dreamer="1" />
          <span class="quote-card">
            <span class="quote-text">Pinterest</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- TikTok — SM +3, SR +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="3" data-style_rebel="1"
                 data-effortlessly_polished="0" data-romantic_dreamer="0" />
          <span class="quote-card">
            <span class="quote-text">TikTok</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- Vintage fairs — RD +3, EP +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="0" data-style_rebel="0"
                 data-effortlessly_polished="1" data-romantic_dreamer="3" />
          <span class="quote-card">
            <span class="quote-text">Vintage fairs</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>
      </div>
    </div>

    <div class="quiz-bottom">
      <div class="progress">
        <div class="progress-label" aria-live="off">Section 4 of 5</div>
        <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-complete"></li>
            <li class="dot is-complete"></li>
            <li class="dot is-complete"></li>
            <li class="dot is-current" style="--fill:25%;" aria-current="step"></li>
            <li class="dot"></li>
          </ol>
      </div>
      <div class="nav-buttons">
        <a class="chip dark" href="#quiz14" role="button">Previous</a>
        <a class="chip primary next-btn" href="#quiz16" role="button">Next</a>
      </div>
    </div>
  </div>
</section>

<!-- =========================
     Q16 — Single — Section 4 (50%) — quotes style
     ========================= -->
<section id="quiz16"
         class="quiz-section q16 quiz-section--quotes single-select"
         aria-labelledby="q16-title">
  <div class="quiz-wrap">
    <div class="quiz-top">
      <div class="quiz-title">
        <h2 id="q16-title">Q16. How often do you share outfits online</h2>
        <p class="note">(Pick one answer that best fits)</p>
      </div>
      <div class="step">Section 4 of 5</div>
    </div>

    <div class="quiz-stage">
      <div class="options">
        <!-- Never — RD +3, EP +1 -->
        <label class="quote-option">
          <input type="radio" name="q16" class="radio"
                 data-street_muse="0" data-style_rebel="0"
                 data-effortlessly_polished="1" data-romantic_dreamer="3" />
          <span class="quote-card">
            <span class="quote-text">Never</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- Rarely — EP +3, RD +1 -->
        <label class="quote-option">
          <input type="radio" name="q16" class="radio"
                 data-street_muse="0" data-style_rebel="0"
                 data-effortlessly_polished="3" data-romantic_dreamer="1" />
          <span class="quote-card">
            <span class="quote-text">Rarely</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- Sometimes — SR +3, SM +1 -->
        <label class="quote-option">
          <input type="radio" name="q16" class="radio"
                 data-street_muse="1" data-style_rebel="3"
                 data-effortlessly_polished="0" data-romantic_dreamer="0" />
          <span class="quote-card">
            <span class="quote-text">Sometimes</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- Often — SM +3, SR +1 -->
        <label class="quote-option">
          <input type="radio" name="q16" class="radio"
                 data-street_muse="3" data-style_rebel="1"
                 data-effortlessly_polished="0" data-romantic_dreamer="0" />
          <span class="quote-card">
            <span class="quote-text">Often</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>
      </div>
    </div>

    <div class="quiz-bottom">
      <div class="progress">
        <div class="progress-label" aria-live="off">Section 4 of 5</div>
        <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-complete"></li>
            <li class="dot is-complete"></li>
            <li class="dot is-complete"></li>
            <li class="dot is-current" style="--fill:50%;" aria-current="step"></li>
            <li class="dot"></li>
          </ol>
      </div>
      <div class="nav-buttons">
        <a class="chip dark" href="#quiz15" role="button">Previous</a>
        <a class="chip primary next-btn" href="#quiz17" role="button">Next</a>
      </div>
    </div>
  </div>
</section>

<!-- =========================
     Q17 — Multi — Section 4 (75%) — quotes style
     ========================= -->
<section id="quiz17"
         class="quiz-section q17 quiz-section--quotes multi-select"
         aria-labelledby="q17-title">
  <div class="quiz-wrap">
    <div class="quiz-top">
      <div class="quiz-title">
        <h2 id="q17-title">Q17. Select brands you would shop from</h2>
        <p class="note">(You can select more than one if it applies)</p>
      </div>
      <div class="step">Section 4 of 5</div>
    </div>

    <div class="quiz-stage">
      <div class="options">
        <!-- Zara — SM +3, EP +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="3" data-style_rebel="0"
                 data-effortlessly_polished="1" data-romantic_dreamer="0" />
          <span class="quote-card">
            <span class="quote-text">Zara</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- H&M — SM +3, SR +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="3" data-style_rebel="1"
                 data-effortlessly_polished="0" data-romantic_dreamer="0" />
          <span class="quote-card">
            <span class="quote-text">H&amp;M</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- Gucci — SR +3, EP +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="0" data-style_rebel="3"
                 data-effortlessly_polished="1" data-romantic_dreamer="0" />
          <span class="quote-card">
            <span class="quote-text">Gucci</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- Thrift stores — RD +3, SM +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="1" data-style_rebel="0"
                 data-effortlessly_polished="0" data-romantic_dreamer="3" />
          <span class="quote-card">
            <span class="quote-text">Thrift stores</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>

        <!-- Uniqlo — EP +3, SM +1 -->
        <label class="quote-option">
          <input type="checkbox" class="check"
                 data-street_muse="1" data-style_rebel="0"
                 data-effortlessly_polished="3" data-romantic_dreamer="0" />
          <span class="quote-card">
            <span class="quote-text">Uniqlo</span>
            <span class="quote-badge" aria-hidden="true"></span>
          </span>
        </label>
      </div>
    </div>

    <div class="quiz-bottom">
      <div class="progress">
        <div class="progress-label" aria-live="off">Section 4 of 5</div>
        <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-complete"></li>
            <li class="dot is-complete"></li>
            <li class="dot is-complete"></li>
            <li class="dot is-current" style="--fill:75%;" aria-current="step"></li>
            <li class="dot"></li>
          </ol>
      </div>
      <div class="nav-buttons">
        <a class="chip dark" href="#quiz16" role="button">Previous</a>
        <a class="chip primary next-btn" href="#quiz18" role="button">Next</a>
      </div>
    </div>
  </div>
</section>


<!-- =========================
     Q18 — Single — Section 4 (100%) — grid-4
     ========================= -->
<section id="quiz18"
         class="quiz-section q18 quiz-section--grid-4 single-select"
         aria-labelledby="q18-title">
  <div class="quiz-wrap">
    <div class="quiz-top">
      <div class="quiz-title">
        <h2 id="q18-title">Q18. What would you splurge on first</h2>
        <p class="note">(Pick one answer that best fits)</p>
      </div>
      <div class="step">Section 4 of 5</div>
    </div>

    <div class="quiz-stage">
      <div class="options">
        <!-- Handbag — EP +3, RD +1 -->
        <label class="option">
          <input type="radio" name="q18" class="radio"
                 data-street_muse="0" data-style_rebel="0"
                 data-effortlessly_polished="3" data-romantic_dreamer="1" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/clothing-purchase/effortlessly-polished-purchase/everyday/everyday-fit-2-purse.webp" alt="Handbag" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Handbag</span>
        </label>

        <!-- Shoes — SR +3, SM +1 -->
        <label class="option">
          <input type="radio" name="q18" class="radio"
                 data-street_muse="1" data-style_rebel="3"
                 data-effortlessly_polished="0" data-romantic_dreamer="0" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/clothing-purchase/effortlessly-polished-purchase/everyday/everyday-fit-1-purse.webp" alt="black heels" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Shoes</span>
        </label>

        <!-- Coat — EP +3, SM +1 -->
        <label class="option">
          <input type="radio" name="q18" class="radio"
                 data-street_muse="1" data-style_rebel="0"
                 data-effortlessly_polished="3" data-romantic_dreamer="0" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/quiz/quiz-outfits/blazer-set.png" alt="Leather Jacket" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Coat</span>
        </label>

        <!-- Vintage dress — RD +3, EP +1 -->
        <label class="option">
          <input type="radio" name="q18" class="radio"
                 data-street_muse="0" data-style_rebel="0"
                 data-effortlessly_polished="1" data-romantic_dreamer="3" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/quiz/quiz-outfits/lace-floral-dress.png" alt="floral dress" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Vintage dress</span>
        </label>
      </div>
    </div>

    <div class="quiz-bottom">
      <div class="progress">
        <div class="progress-label" aria-live="off">Section 4 of 5</div>
        <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-complete"></li>
            <li class="dot is-complete"></li>
            <li class="dot is-complete"></li>
            <li class="dot is-current" style="--fill:100%;" aria-current="step"></li>
            <li class="dot"></li>
          </ol>
      </div>
      <div class="nav-buttons">
        <a class="chip dark" href="#quiz17" role="button">Previous</a>
        <a class="chip primary next-btn" href="#quiz19" role="button">Next</a>
      </div>
    </div>
  </div>
</section>

<!-- =========================
     Q19 — Single — Section 5 (50%) — grid-4
     ========================= -->
<section id="quiz19"
         class="quiz-section q19 quiz-section--grid-4 single-select"
         aria-labelledby="q19-title">
  <div class="quiz-wrap">
    <div class="quiz-top">
      <div class="quiz-title">
        <h2 id="q19-title">Q19. Which style icon inspires you most</h2>
        <p class="note">(Pick one answer that best fits)</p>
      </div>
      <div class="step">Section 5 of 5</div>
    </div>

    <div class="quiz-stage">
      <div class="options">
        <!-- Zendaya — SM +3, SR +1 -->
        <label class="option">
          <input type="radio" name="q19" class="radio"
                 data-street_muse="3" data-style_rebel="1"
                 data-effortlessly_polished="0" data-romantic_dreamer="0" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/quiz/quiz-outfits/zendya.png" alt="Zendaya" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Zendaya</span>
        </label>

        <!-- Rihanna — SR +3, SM +1 -->
        <label class="option">
          <input type="radio" name="q19" class="radio"
                 data-street_muse="1" data-style_rebel="3"
                 data-effortlessly_polished="0" data-romantic_dreamer="0" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/quiz/quiz-outfits/rihanna.png" alt="Rihanna" loading="lazy" decoding="async" width="520" height="700" />
          </span>
          <span class="opt-label">Rihanna</span>
        </label>

        <!-- Lori Harvey — EP +3, RD +1 -->
        <label class="option">
          <input type="radio" name="q19" class="radio"
                 data-street_muse="0" data-style_rebel="0"
                 data-effortlessly_polished="3" data-romantic_dreamer="1" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/quiz/quiz-outfits/lory-harvey.png" alt="Lori Harvey" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Lori Harvey</span>
        </label>

        <!-- Audrey Hepburn — RD +3, EP +1 -->
        <label class="option">
          <input type="radio" name="q19" class="radio"
                 data-street_muse="0" data-style_rebel="0"
                 data-effortlessly_polished="1" data-romantic_dreamer="3" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/quiz/quiz-outfits/audrey-hepbur.png" alt="Audrey Hepbur" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Audrey Hepburn</span>
        </label>
      </div>
    </div>

    <div class="quiz-bottom">
      <div class="progress">
        <div class="progress-label" aria-live="off">Section 5 of 5</div>
        <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-complete"></li>
            <li class="dot is-complete"></li>
            <li class="dot is-complete"></li>
            <li class="dot is-complete"></li>
            <li class="dot is-current" style="--fill:50%;" aria-current="step"></li>
          </ol>
      </div>
      <div class="nav-buttons">
        <a class="chip dark" href="#quiz18" role="button">Previous</a>
        <a class="chip primary next-btn" href="#quiz20" role="button">Next</a>
      </div>
    </div>
  </div>
</section>
<!-- =========================
     Q20 — Single — Section 5 (100%) — grid-4
     ========================= -->
<section id="quiz20"
         class="quiz-section q20 quiz-section--grid-4 single-select"
         aria-labelledby="q20-title">
  <div class="quiz-wrap">
    <div class="quiz-top">
      <div class="quiz-title">
        <h2 id="q20-title">Q20. Pick the body shape that looks like yours</h2>
        <p class="note">(Pick one answer that best fits)</p>
      </div>
      <div class="step">Section 5 of 5</div>
    </div>

    <div class="quiz-stage">
      <div class="options">
        <!-- Hourglass — RD +3, EP +1 -->
        <label class="option">
          <input type="radio" name="q20" class="radio"
                 data-street_muse="0" data-style_rebel="0"
                 data-effortlessly_polished="1" data-romantic_dreamer="3" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/quiz/quiz-outfits/hourglass.png" alt="Hourglass Body Shape" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Hourglass</span>
        </label>

        <!-- Pear — SM +3, RD +1 -->
        <label class="option">
          <input type="radio" name="q20" class="radio"
                 data-street_muse="3" data-style_rebel="0"
                 data-effortlessly_polished="0" data-romantic_dreamer="1" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/quiz/quiz-outfits/pear.png" alt="Pear Body Shape" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Pear</span>
        </label>

        <!-- Triangle — EP +3, SM +1 -->
        <label class="option">
          <input type="radio" name="q20" class="radio"
                 data-street_muse="1" data-style_rebel="0"
                 data-effortlessly_polished="3" data-romantic_dreamer="0" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/quiz/quiz-outfits/triangle.png" alt="Triangle Body Shape" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Triangle</span>
        </label>

        <!-- Rectangle — SR +3, EP +1 -->
        <label class="option">
          <input type="radio" name="q20" class="radio"
                 data-street_muse="0" data-style_rebel="3"
                 data-effortlessly_polished="1" data-romantic_dreamer="0" />
          <span class="tile">
            <span class="badge" aria-hidden="true"></span>
            <img src="./assets/images/quiz/quiz-outfits/rectangle.png" alt="Rectangle Body Shape" loading="lazy" decoding="async" width="520" height="700"/>
          </span>
          <span class="opt-label">Rectangle</span>
        </label>
      </div>
    </div>

    <div class="quiz-bottom">
      <div class="progress">
        <div class="progress-label" aria-live="off">Section 5 of 5</div>
        <ol class="progress-dots" aria-label="Progress">
            <li class="dot is-complete"></li>
            <li class="dot is-complete"></li>
            <li class="dot is-complete"></li>
            <li class="dot is-complete"></li>
            <li class="dot is-current" style="--fill:100%;" aria-current="step"></li>
          </ol>
      </div>
      <div class="nav-buttons">
        <a class="chip dark" href="#quiz19" role="button">Previous</a>
        <button type="button" class="chip primary" id="submit-btn">Get My Results</button>
      </div>
    </div>
  </div>
</section>


  <!-- EverWardrobe Footer -->
  <?php include 'footer.php'; ?>

  <script src="script.js"></script>
</body>


</html>