<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Explore Personas — EverWardrobe</title>

  <!-- Fonts -->
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@600;700&family=Plus+Jakarta+Sans:wght@400;500;600;700&display=swap" rel="stylesheet">

  <link rel="stylesheet" href="main-style.css">
</head>
<body id="capsule-room">
  <!-- SITE HEADER -->
  <?php include 'header.php'; ?>

  <main>
    <!-- HERO -->
    <section class="hero" aria-labelledby="hero-title">
      <div class="container">
        <div>
          <p class="eyebrow">EverWardrobe</p>
          <h1 id="hero-title">Welcome to <br>Capsule Room</h1>
          <p class="lead">Your very own curated outfits. Start shopping looks that are based on your persona.</p>
          <p class="cta-row">
            <a class="btn" href="/index.php">Take a style quiz</a>
          </p>
        </div>
  
        <figure>
          <picture>
            
            <img
              src="./assets/images/home/persona-card.jpg"
              width="700" height="933" alt=""
              decoding="async" fetchpriority="high" loading="eager">
          </picture>
        </figure>
      </div>
    </section>
  
    <!-- CHOOSE YOUR CAPSULE -->
    <section class="picker" aria-labelledby="capsule-heading">
      <div class="container">
        <h2 id="capsule-heading">Choose your capsule</h2>
  
        <ul class="capsule-grid" role="list">
          <li>
            <a href="./personas/street-muse.php" aria-label="Open Street Muse capsule">
              <header>
                <h3>Street Muse</h3>
                <p>Trend-forward, curated cool.</p>
                <div class="previews">
                  <img src="./assets/images/outfits/street-muse/everyday/street-muse-1.jpg"
                       width="160" height="160" alt=""
                       loading="lazy" decoding="async">
                  <img src="./assets/images/outfits/street-muse/everyday/street-muse-2.jpg"
                       width="160" height="160" alt=""
                       loading="lazy" decoding="async">
                </div>
              </header>
              <figure>
                <img
                src="./assets/images/personas/street-muse-2.webp"
                  sizes="(min-width:1200px) 20vw, (min-width:600px) 40vw, 70vw"
                  width="400" height="600" alt="Street Muse persona"
                  loading="lazy" decoding="async">
              </figure>
            </a>
          </li>
  
          <li>
            <a href="./personas/romantic-dreamer.php" aria-label="Open Romantic Dreamer capsule">
              <header>
                <h3>Romantic Dreamer</h3>
                <p>Trend-forward, curated cool.</p>
                <div class="previews">
                  <img src="./assets/images/outfits/romantic-dreamer/everyday/romantic-dreamer-1.jpg" width="160" height="160" alt="" loading="lazy" decoding="async">
                  <img src="./assets/images/outfits/romantic-dreamer/career-wear/romantic-dreamer-2.jpg" width="160" height="160" alt="" loading="lazy" decoding="async">
                </div>
              </header>
              <figure>
                <img
                  src="./assets/images/personas/romantic-dreamer-1.webp"
                  sizes="(min-width:1200px) 20vw, (min-width:600px) 40vw, 70vw"
                  width="400" height="600" alt="Romantic Dreamer persona"
                  loading="lazy" decoding="async">
              </figure>
            </a>
          </li>
  
          <li>
            <a href="./personas/style-rebel.php" aria-label="Open Style Rebel capsule">
              <header>
                <h3>Style Rebel</h3>
                <p>Trend-forward, curated cool.</p>
                <div class="previews">
                  <img src="./assets/images/outfits/style-rebel/everyday/style-rebel-1.jpg" width="160" height="160" alt="" loading="lazy" decoding="async">
                  <img src="./assets/images/outfits/style-rebel/everyday/style-rebel-2.jpg" width="160" height="160" alt="" loading="lazy" decoding="async">
                </div>
              </header>
              <figure>
                <img
                    src="./assets/images/personas/style-rebel-2.webp"
                  sizes="(min-width:1200px) 20vw, (min-width:600px) 40vw, 70vw"
                  width="400" height="600" alt="Style Rebel persona"
                  loading="lazy" decoding="async">
              </figure>
            </a>
          </li>
  
          <li>
            <a href="./personas/effortlessly-polished.php" aria-label="Open Effortlessly Polished capsule">
              <header>
                <h3>Effortlessly Polished</h3>
                <p>Trend-forward, curated cool.</p>
                <div class="previews">
                  <img src="./assets/images/outfits/effortlessly-polished/everyday/effortlessly-polished-1.jpg" width="160" height="160" alt="" loading="lazy" decoding="async">
                  <img src="./assets/images/outfits/effortlessly-polished/career-wear/effortlessly-polished-3.jpg" width="160" height="160" alt="" loading="lazy" decoding="async">
                </div>
              </header>
              <figure>
                <img
                src="./assets/images/personas/effortlessly-polished-1.webp"
                  sizes="(min-width:1200px) 20vw, (min-width:600px) 40vw, 70vw"
                  width="400" height="600" alt="Effortlessly Polished persona"
                  loading="lazy" decoding="async">
              </figure>
            </a>
          </li>
        </ul>
      </div>
    </section>
  </main>

  <!-- SITE FOOTER -->
  <?php include 'footer.php'; ?>

  <script src="script.js"></script>
</body>
</html>