<!-- EverWardrobe Website -->
<!-- By Fasika Kelile -->
<!-- CAPSULE ROOM PAGE html -->
<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
  <!-- Character Encoding -->
  <meta charset="utf-8">
  <!-- Viewport (Responsive Design) -->
  <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover, interactive-widget=overlays-content">
  
  <!-- Description (SEO) -->
  <meta name="description" content="Curated looks and outfit ideas tailored to your style. Mix, match, and shop pieces that work for your real life.">
  
  <!-- Color scheme (respects user preference) -->
  <meta name="color-scheme" content="light dark" />
  <meta name="theme-color" content="#FFF7F0" media="(prefers-color-scheme: light)" />
  <meta name="theme-color" content="#3D3A37" media="(prefers-color-scheme: dark)" />
  
  <!-- Canonical link -->
  <link rel="canonical" href="https://everwardrobe.com/capsule-room/romantic-dreamer-capsule-room.php" />
  
  <!-- Social previews (Open Graph) -->
  <meta property="og:type" content="website" />
  <meta property="og:site_name" content="EverWardrobe" />
  <meta property="og:title" content="Romantic Dreamer Capsule Room — EverWardrobe" />
  <meta property="og:description" content="Soft, whimsical, romantic. Explore your Romantic Dreamer capsule wardrobe with curated looks for Everyday, Career Wear, and Statement styles." />
  <meta property="og:url" content="https://everwardrobe.com/capsule-room/romantic-dreamer-capsule-room.php" />
  <meta property="og:image" content="https://everwardrobe.com/images/og-capsule-romantic-dreamer.jpg" />
  <meta property="og:image:alt" content="Romantic Dreamer Capsule Room — EverWardrobe" />
  
  <!-- Twitter Card -->
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="Romantic Dreamer Capsule Room — EverWardrobe" />
  <meta name="twitter:description" content="Soft, whimsical, romantic. Explore your Romantic Dreamer capsule wardrobe with curated looks for Everyday, Career Wear, and Statement styles." />
  <meta name="twitter:image" content="https://everwardrobe.com/images/og-capsule-romantic-dreamer.jpg" />
  
  <!-- Keywords -->
  <meta name="keywords" content="capsule wardrobe, curated outfits, Romantic Dreamer, fashion styling, style tips, outfit ideas">
  
  <!-- Author & SEO -->
  <meta name="author" content="EverWardrobe">
  <meta name="robots" content="index, follow" />
  <meta name="referrer" content="strict-origin-when-cross-origin" />
  
  <!-- Page Title -->
  <title>Romantic Dreamer Capsule Room — EverWardrobe</title>
  
  <!-- Fonts (brand-locked) -->
  <link rel="preconnect" href="https://fonts.googleapis.com" />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@600;700;900&family=Plus+Jakarta+Sans:wght@400;500;600;700&display=swap" rel="stylesheet" />
  
  <!-- Stylesheet -->
  <link rel="stylesheet" href="../main-style.css" />
</head>
<body id="capsule-persona" data-persona="romantic-dreamer" style="--sticky-top:0px">
  <!-- a11y header (kept semantic, visually hidden) -->
  <header class="visually-hidden">
    <p>Romantic Dreamer Capsule Room</p>
  </header>

  <!-- =========================
       PAGE LAYOUT (two columns ≥900)
       ========================= -->
  <main data-capsule="cap-layout">
    <!-- ============ LEFT: PERSONA PANEL ============ -->
    <aside data-capsule="cap-persona" aria-labelledby="persona-title">
      <header>
        <p data-role="persona-label" aria-hidden="true">Persona</p>
        <h1 id="persona-title">
          Romantic<br />Dreamer <span data-role="title-accent" aria-hidden="true"></span>
        </h1>
        <p data-role="persona-tagline">Ethereal, feminine, vintage.</p>
      </header>

      <!-- Portrait -->
      <figure data-role="persona-portrait">
        <div data-role="portrait-frame">
          <img
            src="../assets/images/personas/romantic-dreamer-1.webp"
            alt="Romantic Dreamer persona portrait"
            loading="lazy"
            decoding="async"
          />
        </div>
      </figure>

      <!-- Actions -->
      <nav aria-label="Persona actions">
        <a data-button="primary" data-variant="outline" href="../personas/romantic-dreamer.php">Back to Romantic Dreamer</a>
        <a data-button="primary" data-variant="outline" href="../quiz.php">Retake Quiz</a>
      </nav>

      <!-- Meta -->
      <div data-role="persona-meta">
        <small><strong>Romantic Dreamer</strong> — curated for you.</small>
        <a data-role="quiz-retake" href="../quiz.php">Start Over</a>
      </div>
    </aside>

    <!-- ============ RIGHT: CATALOG (THEMES & LOOKS) ============ -->
    <section data-capsule="cap-catalog" aria-label="Capsule themes and looks">
      <!-- Sticky theme tabs (mobile-first) -->
      <nav data-capsule="cap-tabs" role="tablist" aria-label="Browse by theme">
        <span data-role="tabs-label">Themes</span>
        <div data-role="tabs-divider" aria-hidden="true"></div>

        <button role="tab" data-theme="everyday" aria-selected="true">Everyday</button>
        <button role="tab" data-theme="workwear" aria-selected="false">Career Wear</button>
        <button role="tab" data-theme="statement" aria-selected="false">Statement</button>
        <button role="tab" data-theme="all" aria-selected="false">All</button>
      </nav>

      <!-- Themes wrapper -->
      <div data-capsule="cap-themes" aria-live="polite" id="capsule-start">
        <!-- Everyday -->
        <section data-capsule="cap-theme" data-theme="everyday">
          <div data-role="theme-head" role="presentation"><h2>Everyday</h2></div>
          <ul data-role="theme-grid" role="list">
            <li data-capsule="cap-look">
              <h3>On-the-Go</h3>
              <figure data-role="look-image">
                <img src="../assets/images/outfits/romantic-dreamer/everyday/romantic-dreamer-1.jpg" alt="On-the-Go look board" loading="lazy" decoding="async" />
              </figure>
              <p data-role="cta"><a data-button="primary" href="/looks/rd-ed-otg-1">View &amp; Shop Look</a></p>
            </li>
            <li data-capsule="cap-look">
              <h3>Coffee Run</h3>
              <figure data-role="look-image">
                <img src="../assets/images/outfits/romantic-dreamer/everyday/romantic-dreamer-2.jpg" alt="Coffee Run look board" loading="lazy" decoding="async" />
              </figure>
              <p data-role="cta"><a data-button="primary" href="/looks/rd-ed-cr-1">View &amp; Shop Look</a></p>
            </li>
            <li data-capsule="cap-look">
              <h3>Weekend Mood</h3>
              <figure data-role="look-image">
                <img src="../assets/images/outfits/romantic-dreamer/everyday/romantic-dreamer-3.jpg" alt="Weekend Mood look board" loading="lazy" decoding="async" />
              </figure>
              <p data-role="cta"><a data-button="primary" href="/looks/rd-ed-wm-1">View &amp; Shop Look</a></p>
            </li>
          </ul>
        </section>

        <!-- Workwear -->
        <section data-capsule="cap-theme" data-theme="workwear">
          <div data-role="theme-head" role="presentation"><h2>Career Wear</h2></div>
          <ul data-role="theme-grid" role="list">
            <li data-capsule="cap-look">
              <h3>Boardroom Edge</h3>
              <figure data-role="look-image">
                <img src="../assets/images/outfits/romantic-dreamer/career-wear/romantic-dreamer-1.jpg" alt="Boardroom Edge look board" loading="lazy" decoding="async" />
              </figure>
              <p data-role="cta"><a data-button="primary" href="/looks/rd-ww-be-1">View &amp; Shop Look</a></p>
            </li>
            <li data-capsule="cap-look">
              <h3>Soft Suit</h3>
              <figure data-role="look-image">
                <img src="../assets/images/outfits/romantic-dreamer/career-wear/romantic-dreamer-2.jpg" alt="Soft Suit look board" loading="lazy" decoding="async" />
              </figure>
              <p data-role="cta"><a data-button="primary" href="/looks/rd-ww-ss-1">View &amp; Shop Look</a></p>
            </li>
            <li data-capsule="cap-look">
              <h3>Friday Ease</h3>
              <figure data-role="look-image">
                <img src="../assets/images/outfits/romantic-dreamer/career-wear/romantic-dreamer-3.jpg" alt="Friday Ease look board" loading="lazy" decoding="async" />
              </figure>
              <p data-role="cta"><a data-button="primary" href="/looks/rd-ww-fe-1">View &amp; Shop Look</a></p>
            </li>
          </ul>
        </section>

        <!-- Statement -->
        <section data-capsule="cap-theme" data-theme="statement">
          <div data-role="theme-head" role="presentation"><h2>Statement</h2></div>
          <ul data-role="theme-grid" role="list">
            <li data-capsule="cap-look">
              <h3>Graphic Pop</h3>
              <figure data-role="look-image">
                <img src="../assets/images/outfits/romantic-dreamer/statememt/romantic-dreamer-1.jpg" alt="Graphic Pop look board" loading="lazy" decoding="async" />
              </figure>
              <p data-role="cta"><a data-button="primary" href="/looks/rd-st-gp-1">View &amp; Shop Look</a></p>
            </li>
            <li data-capsule="cap-look">
              <h3>Cozy Statement</h3>
              <figure data-role="look-image">
                <img src="../assets/images/outfits/romantic-dreamer/statememt/romantic-dreamer-2.jpg" alt="Cozy Statement look board" loading="lazy" decoding="async" />
              </figure>
              <p data-role="cta"><a data-button="primary" href="/looks/rd-st-cs-1">View &amp; Shop Look</a></p>
            </li>
            <li data-capsule="cap-look">
              <h3>Night Out</h3>
              <figure data-role="look-image">
                <img src="../assets/images/outfits/romantic-dreamer/statememt/romantic-dreamer-3.jpg" alt="Night Out look board" loading="lazy" decoding="async" />
              </figure>
              <p data-role="cta"><a data-button="primary" href="/looks/rd-st-no-1">View &amp; Shop Look</a></p>
            </li>
          </ul>
        </section>
      </div>
    </section>
  </main>

  <!-- a11y footer (kept semantic, visually hidden) -->
  <footer class="visually-hidden">
    <p>© EverWardrobe</p>
  </footer>

  <script src="/script.js" defer></script>
</body>
</html>