<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>About Us — EverWardrobe</title>

  <!-- Brand fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@600;700&family=Plus+Jakarta+Sans:wght@300;400;500;600&display=swap" rel="stylesheet">

  <link rel="stylesheet" href="main-style.css" />
</head>

<body id="about">
  <a class="skip" href="#main">Skip to content</a>

  <?php include 'header.php'; ?>

  <main id="main">
    <!-- HERO -->
    <section class="hero" aria-label="Intro">
      <div class="container">
        <div class="hero-text">
          <p class="eyebrow">EverWardrobe</p>
          <h1>Capsule wardrobes<br>that actually work.</h1>
          <p class="lede">We edit the noise so you can dress with clarity—fewer, better pieces that mix, match, and repeat with ease.</p>

          <ul class="chips" aria-label="Brand pillars">
            <li>Wearability first</li>
            <li>Effortless formulas</li>
            <li>Fewer, better</li>
            <li>Transparent picks</li>
          </ul>

          <ul class="stats" aria-label="Quick stats">
            <li><strong>4</strong> style lanes</li>
            <li><strong>3</strong> personas</li>
            <li><strong>2</strong> pieces / outfit</li>
          </ul>
        </div>

        <div class="hero-visual" aria-label="Outfit collage">
          <figure>
            <img src="./assets/images/home/about-us.jpg" alt="Hero model wearing capsule outfit" width="600" height="800" />
          </figure>
          <div class="hero-tiles" aria-hidden="true">
            <img src="./assets/images/home/about-us-hero-1.png" alt="Outfit detail" width="380" height="380" />
            <img src="./assets/images/home/about-us-hero-2.png" alt="Outfit styling" width="380" height="380" />
          </div>
        </div>
      </div>
    </section>

    <!-- STORY -->
    <section class="story" aria-label="Our Story">
      <div class="container">
        <div class="media" aria-label="Behind-the-scenes moments">
          <img src="./assets/images/personas/effortlessly-polished-1.webp" alt="EverWardrobe team curating" width="800" height="600" />
          <img src="./assets/images/personas/street-muse-1.webp" alt="Team discussing fashion" width="800" height="600" />
          <img src="./assets/images/outfits/street-muse/everyday/street-muse-1.jpg" alt="Styling session" width="800" height="600" />
        </div>

        <div>
          <p class="label"><svg viewBox="0 0 20 20" aria-hidden="true"><circle cx="10" cy="10" r="9"/></svg> Our Story</p>
          <h2>We're here to make getting dressed effortless.</h2>
          <p>We started with one goal: make everyday dressing effortless. By focusing on wearability, cohesion, and quality, we design capsules that fit actual lives—not just photos.</p>

          <ul class="checklist">
            <li>Wearability first</li>
            <li>Range &amp; representation</li>
            <li>Fewer, better</li>
            <li>Transparent picks</li>
          </ul>
          <p class="signature">— EverWardrobe</p>
        </div>
      </div>
    </section>

    <!-- HOW WE BUILD -->
    <section class="build" aria-label="How we build a capsule">
      <div class="container">
        <div class="frame" role="group" aria-labelledby="how-h2">
          <div class="left">
            <h2 id="how-h2">How we build a capsule</h2>
            <p class="lede">We craft personalized wardrobes aligned with your unique style, ensuring stylish, cohesive outfits that are easy to put together.</p>

            <nav aria-label="Build steps" class="steps">
              <a>Define</a><a>Edit</a><a>Style</a>
            </nav>
            <p class="note">Our edits stay coherent with smart swaps</p>
          </div>

          <div class="cards">
            <article>
              <div class="icon" aria-hidden="true">
                <svg viewBox="0 0 48 48"><circle cx="24" cy="24" r="22" fill="none"/><path d="M24 14c5 0 9 4 9 9 0 3-1.6 5.6-4 7v3h-10v-3c-2.4-1.4-4-4-4-7 0-5 4-9 9-9z" fill="none"/></svg>
              </div>
              <h3>Style Quiz</h3>
              <p>Answer a few questions to define your fashion preferences.</p>
              <a href="index.html">Take quiz →</a>
            </article>

            <article>
              <div class="icon" aria-hidden="true">
                <svg viewBox="0 0 48 48"><circle cx="24" cy="18" r="8" fill="none"/><path d="M10 40c3-6 9-9 14-9s11 3 14 9" fill="none"/></svg>
              </div>
              <h3>Fashion Persona</h3>
              <p>Get a personalized style profile tailored to you.</p>
              <a href="explore-personas.php">Explore personas →</a>
            </article>

            <article>
              <div class="icon" aria-hidden="true">
                <svg viewBox="0 0 48 48"><path d="M24 14c0-3 3-4 3-6 0-2-1.5-4-4-4-2 0-4 2-4 4" fill="none"/><path d="M6 34l18-10 18 10v4H6z" fill="none"/></svg>
              </div>
              <h3>Capsule Deck</h3>
              <p>Receive a curated set of wardrobe pieces that remix beautifully.</p>
             
            </article>

            <article>
              <div class="icon" aria-hidden="true">
                <svg viewBox="0 0 48 48"><rect x="10" y="10" width="28" height="28" rx="3" fill="none"/><path d="M16 18h16M16 24h16M16 30h10"/></svg>
              </div>
              <h3>Outfit List</h3>
              <p>Ready-made outfit ideas pulled from your capsule.</p>
            </article>
          </div>
        </div>
      </div>
    </section>

    <!-- VALUES -->
    <section class="values" aria-label="What we value">
      <div class="container">
        <div class="grid">
          <div>
            <h2>What we value</h2>
            <ul class="value-list">
              <li><span class="value-icon" aria-hidden="true"><svg viewBox="0 0 48 48"><circle cx="24" cy="24" r="22"/><path d="M14 25l6 6 14-14" stroke-linecap="round" fill="none"/></svg></span>Wearability first</li>
              <li><span class="value-icon" aria-hidden="true"><svg viewBox="0 0 48 48"><circle cx="24" cy="24" r="22"/><circle cx="18" cy="22" r="3"/><circle cx="30" cy="22" r="3"/><path d="M12 34c3-5 9-6 12-6s9 1 12 6" fill="none"/></svg></span>Range &amp; representation</li>
              <li><span class="value-icon" aria-hidden="true"><svg viewBox="0 0 48 48"><circle cx="24" cy="24" r="22"/><path d="M24 10l6 10H18z"/><path d="M18 28h12"/></svg></span>Fewer, better</li>
              <li><span class="value-icon" aria-hidden="true"><svg viewBox="0 0 48 48"><circle cx="24" cy="24" r="22"/><circle cx="24" cy="24" r="10" fill="none"/><path d="M30 30l6 6"/></svg></span>Transparent picks</li>
            </ul>
          </div>

          <aside class="numbers" aria-label="By the numbers">
            <h3>Our edit, by the numbers</h3>
            <div class="numbers-grid">
              <div><strong>4</strong><span>style personas</span></div>
              <div><strong>3</strong><span>style lanes</span></div>
              <div><strong>2</strong><span>pieces / outfit</span></div>
              <div><strong>4+</strong><span>outfits / capsule</span></div>
            </div>
            <p class="caption">Affiliate shopping links may appear. No pay-to-place.</p>
          </aside>
        </div>
      </div>
    </section>

    <!-- PERSONAS -->
    <section class="personas" aria-label="Find your style persona">
      <div class="container">
        <header>
          <h2>Find Your Style Persona</h2>
          <p>Take a quick, visual quiz to reveal your inner fashion icon. Get a personalized persona breakdown that highlights your style habits and where your look truly shines.</p>
        </header>

        <div class="persona-grid" role="list">
          <article role="listitem">
            <h3>Street Muse</h3>
            <img src="./assets/images/personas/street-muse-2.webp" alt="Street Muse style persona" width="400" height="260" />
            <ul><li>Trend-setting yet relatable</li><li>Confidence &amp; coolness</li></ul>
            <a href="personas/street-muse.php">See capsule</a>
          </article>

          <article role="listitem">
            <h3>Style Rebel</h3>
            <img src="./assets/images/personas/style-rebel-2.webp" alt="Style Rebel style persona" width="400" height="260" />
            <ul><li>Bold &amp; expressive</li><li>Effortlessly mixes edgy pieces</li></ul>
            <a href="personas/style-rebel.php">See capsule</a>
          </article>

          <article role="listitem">
            <h3>Effortlessly Polished</h3>
            <img src="./assets/images/personas/effortlessely-polished-2.webp" alt="Effortlessly Clean style persona" width="400" height="260" />
            <ul><li>Minimal with a modern twist</li><li>Polished but never fussy</li></ul>
            <a href="personas/effortlessly-polished.php">See capsule</a>
          </article>

          <article role="listitem">
            <h3>Romantic Dreamer</h3>
            <img src="./assets/images/personas/romantic-dreamer-2.webp" alt="Romantic Dreamer style persona" width="400" height="260" />
            <ul><li>Soft, vintage-inspired aesthetic</li></ul>
            <a href="personas/romantic-dreamer.php">See capsule</a>
          </article>
        </div>
      </div>
    </section>

    <!-- CTA -->
    <section class="cta" aria-labelledby="cta-h2">
      <div class="container">
        <div>
          <p class="eyebrow">EverWardrobe</p>
          <h2 id="cta-h2">Ready for a wardrobe that just works?</h2>
          <p>Take the 5–6-minute style quiz and get your capsule.</p>

          <div class="cta-actions" role="group" aria-label="Primary actions">
            <a class="primary" href="index.php">Start your style quiz</a>
            <a class="outline" href="explore-personas.php">Browse capsules</a>
          </div>
          <p class="caption">No spam. Some links are affiliate; never pay-to-place.</p>
        </div>

        <div class="cta-visual" aria-label="Capsule collage">
          <img class="tall" src="./assets/images/outfits/street-muse/statememt /street-muse-2.jpg" alt="Featured capsule collection" width="600" height="800" />
          <div class="row">
            <img src="./assets/images/outfits/romantic-dreamer/career-wear/romantic-dreamer-2.jpg" alt="Capsule styling option 1" width="280" height="280" />
            <img src="./assets/images/outfits/effortlessly-polished/career-wear/effortlessly-polished-1.jpg" alt="Capsule styling option 2" width="280" height="280" />
          </div>
        </div>
      </div>
    </section>
  </main>

  <!-- FOOTER -->
  <?php include 'footer.php'; ?>

  <script src="/script.js" defer></script>
</body>

</html>